package com.hero.objects.talents;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.characteristics.Intelligence;
import com.hero.ui.dialog.DangerSenseDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Constants;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class DangerSense extends Talent {

	private static String xmlID = "DANGER_SENSE";

	public DangerSense(Element root) {
		super(root, DangerSense.xmlID);
	}

	@Override
	public ArrayList<Adder> getAssignedAdders() {
		ArrayList<Adder> ret = super.getAssignedAdders();
		Adder where = null;
		Adder which = null;
		Adder intuitional = null;
		if (GenericObject.findObjectByID(ret, "AREA") != null) {
			where = (Adder) GenericObject.findObjectByID(ret, "AREA");
		}
		if (GenericObject.findObjectByID(ret, "SENSITIVITY") != null) {
			which = (Adder) GenericObject.findObjectByID(ret, "SENSITIVITY");
		}
		if (GenericObject.findObjectByID(ret, "INTUITIONAL") != null) {
			intuitional = (Adder) GenericObject.findObjectByID(ret,
					"INTUITIONAL");
		}
		if (intuitional == null) {
			return ret;
		} else if (((where == null) || where.getSelectedOption().getXMLID()
				.equals("IMMEDIATE_VICINITY"))
				&& ((which == null) || which.getSelectedOption().getXMLID()
						.equals("OUT_OF_COMBAT"))) {
			return ret;
		} else {
			ret.remove(intuitional);
			return ret;
		}
	}

	@Override
	public ArrayList<Adder> getAvailableAdders() {
		ArrayList<Adder> ret = (ArrayList<Adder>) super.getAvailableAdders()
				.clone();
		Adder where = null;
		Adder which = null;
		Adder intuitional = null;
		if (GenericObject.findObjectByID(ret, "AREA") != null) {
			where = (Adder) GenericObject.findObjectByID(ret, "AREA");
		}
		if (GenericObject.findObjectByID(ret, "SENSITIVITY") != null) {
			which = (Adder) GenericObject.findObjectByID(ret, "SENSITIVITY");
		}
		if (GenericObject.findObjectByID(ret, "INTUITIONAL") != null) {
			intuitional = (Adder) GenericObject.findObjectByID(ret,
					"INTUITIONAL");
		}
		if (intuitional == null) {
			return ret;
		} else if (((where == null) || where.getSelectedOption().getXMLID()
				.equals("IMMEDIATE_VICINITY"))
				&& ((which == null) || which.getSelectedOption().getXMLID()
						.equals("OUT_OF_COMBAT"))) {
			return ret;
		} else {
			ret.remove(intuitional);
			return ret;
		}
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias();
		String area = "self only";
		String sensitivity = "in combat";
		if (GenericObject.findObjectByID(getAssignedAdders(), "AREA") != null) {
			Adder ad = (Adder) GenericObject.findObjectByID(
					getAssignedAdders(), "AREA");
			ad.setDisplayInString(false);
			if (ad.isSelected()) {
				area = ad.getSelectedOption().getAlias();
			}
		}
		if (GenericObject.findObjectByID(getAssignedAdders(), "SENSITIVITY") != null) {
			Adder ad = (Adder) GenericObject.findObjectByID(
					getAssignedAdders(), "SENSITIVITY");
			ad.setDisplayInString(false);
			if (ad.isSelected()) {
				sensitivity = ad.getSelectedOption().getAlias();
			}
		}
		if ((getName() != null) && (getName().trim().length() > 0)) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}

		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		ret += " (" + area + ", " + sensitivity;
		if (getSelectedOption() != null) {
			ret += ", " + getSelectedOption().getAlias();

			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += ", " + adderString;
			}
		} else {
			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += ", " + adderString;
			}
		}
		ret += ")";
		ret += getModifierString();
		if ((getRoll() != null) && (getRoll().trim().length() > 0)) {
			ret += " " + getRoll();
		}
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public GenericDialog getDialog(boolean isNew, boolean isPower) {
		DangerSenseDialog dialog = new DangerSenseDialog(this, isNew, isPower);
		return dialog;
	}

	@Override
	public String getRoll() {
		String ret = "";
		if (HeroDesigner.getActiveHero() != null) {
			Characteristic charac = HeroDesigner.getActiveHero()
					.getCharacteristic(Constants.INT);
			int per1 = 11;
			int per2 = 11;
			if (charac != null && charac.getPerIncrease() > 0 && charac.getPerIncreaseLevels() > 0) {
			
	        	int levels = (int)Rounder.roundHalfUp(charac.getPerIncrease()*charac.getPrimaryValue()/charac.getPerIncreaseLevels());
	        	per1 = (int) (9 + Rounder.roundHalfUp(levels));
	        	levels = (int)Rounder.roundHalfUp(charac.getPerIncrease()*charac.getSecondaryValue()/charac.getPerIncreaseLevels());
	        	per2 = (int) (9 + Rounder.roundHalfUp(levels));
	        }
			int roll = (int) Rounder.roundHalfUp(per1 + getLevels()
					* getLevelValue());
			int roll2 = (int) Rounder.roundHalfUp(per2 + getLevels()
					* getLevelValue());
			if (getLevels() < 0) {
				roll = getMinimumLevel();
			}
			ret += roll + "-";
			if (roll != roll2) {
				ret += "/" + roll2 + "-";
			}
		} else {
			ret = "11-";
		}
		return ret;
	}

	@Override
	public Element getSaveXML() {
		Element root = super.getSaveXML();
		root.setAttribute("LEVELS", "" + getLevels());
		return root;
	}
}